/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.BuilderMoc;
import cds.allsky.Context;
import cds.fits.HeaderFits;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;

public class BuilderMocError
extends BuilderMoc {
    public BuilderMocError(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MOCERROR;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
    }

    @Override
    protected void createMoc(String path) throws Exception {
        this.moc = new SMoc();
        this.fileOrder = this.mocOrder = Util.getMaxOrderByPath(path);
        this.tileOrder = this.context.getTileOrder();
        try {
            if (this.context.mocIndex == null) {
                this.context.loadMocIndex();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mocOrder = this.fileOrder;
        this.ext = this.getDefaultExt(path);
        if (this.ext != null) {
            this.context.info("MOCERROR scanning based on " + this.ext + " tiles (order=" + this.fileOrder + ") ");
        }
        this.frameCube = -1;
        if (this.context.getDepth() > 10) {
            this.frameCube = this.context.getDepth() / 2;
        }
        this.moc.setMocOrder(this.mocOrder);
        String outputFile = path + cds.tools.Util.FS + "MocError.fits";
        this.moc.setSpaceSys(this.getFrame());
        this.generateMoc(this.moc, this.fileOrder, path);
        if (this.moc.isEmpty()) {
            this.context.info("MOCERROR empty (no error tiles detected)");
        } else {
            this.context.warning("MOCERROR saved as MocError.fits");
            this.moc.write(outputFile);
        }
    }

    private String getDefaultExt(String path) {
        return "fits";
    }

    @Override
    protected void generateMoc(SMoc moc, int fileOrder, String path) throws Exception {
        this.initStat();
        moc.bufferOn();
        File f = new File(path + Util.FS + "Norder" + fileOrder);
        File[] sf = f.listFiles();
        if (sf == null || sf.length == 0) {
            throw new Exception("No tiles found !");
        }
        for (int i = 0; i < sf.length; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (!sf[i].isDirectory()) continue;
            File[] sf1 = sf[i].listFiles();
            for (int j = 0; j < sf1.length; ++j) {
                String file = sf1[j].getAbsolutePath();
                long npix = Util.getNpixFromPath(file);
                if (npix == -1L) continue;
                String e = this.getExt(file);
                if (this.ext == null) {
                    this.ext = e;
                } else if (!this.ext.equals(e)) continue;
                if (this.frameCube > -1 && this.getCubeFrameNumber(file) != this.frameCube) continue;
                this.generateTileMoc(moc, sf1[j], fileOrder, npix);
            }
        }
        moc.bufferOff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generateTileMoc(SMoc moc, File f, int fileOrder, long npix) throws Exception {
        this.updateStat();
        try (MyInputStream dis = null;){
            dis = new MyInputStream(new FileInputStream(f));
            dis = dis.startRead();
            HeaderFits header = new HeaderFits(dis);
            dis.close();
            dis = null;
            long w = header.getIntFromHeader("NAXIS1");
            long h = header.getIntFromHeader("NAXIS2");
            long n = Math.abs(header.getIntFromHeader("BITPIX") / 8);
            long size = 2880L + w * h * n;
            long len = f.length();
            if (len < size) {
                moc.add(this.mocOrder, npix);
            }
        }
    }
}

